#!/bin/sh
#
# File: tce-unload
# Desc: Tries to unload a tce from the system by un-mounting the loopdevice, removing
# a symbolic links, and removing tce.installed
#

# make sure that the script will fail with an exit code on any error
set -e

package=$1
if [ -z "$package" ]; then
	echo "Error: Missing module name"
	exit 1
fi

sudo rm -f /usr/local/tce.installed/$package
if [ -d /tmp/tcloop/$package ]; then
	f=`cd /tmp/tcloop/$package; find ! -type d | sed -e "s%^./%/%"`
	for l in $f; do
		if [ -s $l ]; then
			linkto=`readlink $l`
			if [ "$linkto" == "/tmp/tcloop/$package$l" ]; then
				sudo rm $l
			fi
		fi
	done
	sudo umount -d /tmp/tcloop/$package
	sudo rmdir /tmp/tcloop/$package
fi
