#!/usr/bin/env python3
#
# A simple example of how to use commands with mmWSClient
# For a list of available functions, refer to:
# https://docs.menandmice.com/en/latest/guides/user-manual/json_rpc/
#
from mmWSClient import Client


webServer = "micetro.demo"
username = "a_user"
password = "secret"
###JWD
webServer = "http://localhost:8111/mmws"
username = "administrator"
password = "administrator"

print("Connecting to Micetro web server:", webServer)
client = Client(server=webServer, username=username, password=password)


servers = client.GetDNSServers()
print()
print("Total number of servers:", servers["totalResults"])
for server in servers["dnsServers"]:
    print(server["name"])

zones = client.GetDNSZones()
print()
print("Total number of zones:", zones["totalResults"])
for zone in zones["dnsZones"]:
    print(zone["name"])

if zones["totalResults"] > 0:
    # Get records from the first zone listed
    # but at most only the first 4 records
    firstZone = zones["dnsZones"][0]
    records = client.GetDNSRecords(dnsZoneRef=firstZone["ref"], limit=4)

    print()
    print("First 4 records in the first zone: {}".format(firstZone["name"]))
    for record in records["dnsRecords"]:
        print(
            "{}\t{}\t{}\t{}".format(
                record["name"], record["ttl"], record["type"], record["data"]
            )
        )

# check if we have any .com or .net zones and if so list them out
zones = client.GetDNSZones(filter="name=$.com. or name=$.net.")
print()
print("The following .com zones where found...")
for zone in zones["dnsZones"]:
    print(zone["name"])
